using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityStandardAssets.Characters.FirstPerson;

public class GameManager : MonoBehaviour
{
    public Transform spawnPoint;

    public GameObject GuideMeOut;
    public GameObject player;


    public float totalTimeElapsed = 0;
    public bool isGameOver = false;

    private FirstPersonController fpsController;

    // Start is called before the first frame update
    void Start()
    {
        
        Physics.autoSyncTransforms = true;
    }

    // Update is called once per frame
    void Update()
    {
        if (isGameOver)
            return;

        totalTimeElapsed += Time.deltaTime;
    }

    //activate the guide to lead you out of the maze
    public void PowerUpOne()
    {
        GuideMeOut.SetActive(true);
    }

    //respawn at start if hit by ball
    public void Respawn() 
    {
            player.transform.position = spawnPoint.position;
            player.transform.rotation = spawnPoint.rotation;
    }
}
